/*
@@@BUILDINFO@@@ aftereffects-13.5.jsx 13.5
*/

/*
@@@START_XML@@@
<?xml version="1.0" encoding="UTF-8"?>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="en_US">
     <dc:title>Adobe After Effects CC 2015</dc:title>
     <dc:description>This script enables other applications to communicate with Adobe After Effects CC 2015.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="fr_FR">
     <dc:title>Adobe After Effects CC 2015</dc:title>
     <dc:description>Ce script permet à d'autres applications de communiquer avec Adobe After Effects CC 2015.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="de_DE">
     <dc:title>Adobe After Effects CC 2015</dc:title>
     <dc:description>Mithilfe dieses Skripts können andere Anwendungen mit Adobe After Effects CC 2015 kommunizieren.</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="it_IT">
     <dc:title>Adobe After Effects CC 2015</dc:title>
     <dc:description>Questo script consente ad altre applicazioni di comunicare con Adobe After Effects CC 2015</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="es_ES">
     <dc:title>Adobe After Effects CC 2015</dc:title>
     <dc:description>Este script posibilita que otras aplicaciones se comuniquen con Adobe After Effects CC 2015</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ja_JP">
     <dc:title>Adobe After Effects CC 2015</dc:title>
     <dc:description>このスクリプトは、他のアプリケーションと Adobe After Effects CC 2015 との通信を有効にします。</dc:description>
</ScriptInfo>
<ScriptInfo xmlns:dc="http://purl.org/dc/elements/1.1/" xml:lang="ko_KR">
     <dc:title>Adobe After Effects CC 2015</dc:title>
     <dc:description>이 스크립트를 사용하면 다른 응용 프로그램에서 Adobe After Effects CC 2015 와 통신할 수 있습니다.</dc:description>
</ScriptInfo>
@@@END_XML@@@
*/

//$.level = 1; debugger;

aftereffects13 = {};

aftereffects13.AfterEffectsTargetName = "aftereffects-13.5"
aftereffects13.AfterEffectsAppName = "aftereffects"
aftereffects13.AfterEffectsVersion = "13.5"
aftereffects13.BridgeTargetName = "bridge"

/**
**	Open Event
**
**	The event is:
**		type - document
**		location - document
**		object - document
**
**	To get the selection use object.selections.
**
*/
aftereffects13.eventHandler = function(event)
{
	var retval = {};
	retval.handled = false;

	if ( event.type == "open" &&
		event.location == "document" &&
		event.object.constructor.name == "Document" &&
		app.document.owner == aftereffects13.AfterEffectsTargetName)
	{
		var sels = event.object.groupedSelections;
		var files = [];
		
		for (var i = 0; i < sels.length; i++)
		{
			var sub_sels = sels[i];
			var sub_files = [];
			for (var j= 0; j < sub_sels.length; j++) {
				sub_files[j] = sub_sels[j].spec;
			}
			files[i] = sub_files;
		}

		aftereffects13.open(files);
		retval.handled = true;
	}

	return retval;
}

if(BridgeTalk.appName == aftereffects13.BridgeTargetName)
{
	app.eventHandlers.push( { handler:aftereffects13.eventHandler } );
}

/**
**	fileArrayToString
**
**	This routine create a string for the array of array of files where
** sub-array of 1 element is an individual file and a sub-array of 
** multiple elements is a sequence that we can transmit
**	over BridgeTalk as text, like this:
**
**	Array (Array(File ('path1')), Array(File ('path1'), File ('path3')))
*/
aftereffects13.fileArrayToString = function (files)
{
    var filesString = new String ("Array (");
    
	for (var index = 0; index < files.length; index++)
    {
		if (index > 0) {
			filesString += ", ";
		} 
			
		filesString += "Array (";
		
		var sub_files = files[index];
		
		for (var sub_index = 0; sub_index < sub_files.length; sub_index++) {
			if (sub_index > 0)
			{
				filesString += ", ";
			}
	
			filesString += "File ('" + sub_files[sub_index].absoluteURI.toString() + "')";
		}
		// close the Array
		filesString += ")";
    }
    
    // close the Array
    filesString += ")";
    
    return filesString;
}

//
// aftereffects13 Cross DOM
//
aftereffects13.executeScript = function(script)
{
	var btMessage = new BridgeTalk;
	btMessage.target = aftereffects13.AfterEffectsTargetName;
	btMessage.body = script;
	btMessage.send();
}


aftereffects13.getExtension = function(filename)
{
	var	dot_index = filename.lastIndexOf('.');
	
	return filename.substring(dot_index);
}

aftereffects13.applyPreset = function(filepath)
{
	if (app.project.activeItem instanceof CompItem) {
 		if(app.project.activeItem.selectedLayers.length) {
 			for (aLayer in app.project.activeItem.selectedLayers) {
 				app.project.activeItem.selectedLayers[aLayer].applyPreset(File(filepath));
 			}
 		} else {
 			app.project.activeItem.applyPreset(File(filepath));
 		}
 	}
}

aftereffects13.open = function(target)
{	
	if (BridgeTalk.appName == aftereffects13.AfterEffectsAppName && BridgeTalk.appVersion == aftereffects13.AfterEffectsVersion)
	{	
		var	first_file_array = target[0];
		var	ext = aftereffects13.getExtension(first_file_array[0].name);
		var	is_project = (ext == ".aep");
		var	is_template_proj = (ext == ".aet");
		
		BridgeTalk.bringToFront( aftereffects13.AfterEffectsAppName );
		
		app.activate();
		
		if (target.length == 1 && first_file_array.length == 1 && (is_project || is_template_proj)) {
			try {
				if (is_project) {
					app.open(File(first_file_array[0].fsName));
				} else {
					app.openTemplate(File(first_file_array[0].fsName));
				}
			} catch(e) {
				alert(e);
			}
		} else { 
			for (var index = 0; index < target.length; index++)
			{
				try {
					var file_subarray = target[index];
					var len = file_subarray.length;
					
					if (len == 1) {
						if (aftereffects13.getExtension(file_subarray[0].name) == ".ffx") {
							aftereffects13.applyPreset(file_subarray[0].fsName);
						} else {
							var imp_options = new ImportOptions(new File(file_subarray[0].fsName));
							app.project.importFile(imp_options);
						}
					} else {	// sequence
						var file_name1 = file_subarray[0].fsName;
						var file_name2 = file_subarray[len -1].fsName;
						var imp_options = new ImportOptions(new File(file_name1));
						var seq_range_start = imp_options.isFileNameNumbered(file_name1);
						var seq_range_end = imp_options.isFileNameNumbered(file_name2);
						
						if (seq_range_start.isNumbered && seq_range_end.isNumbered) {
								imp_options.rangeStart = seq_range_start.num;
								imp_options.rangeEnd = seq_range_end.num;
						}
						imp_options.sequence = true;
						app.project.importFile(imp_options);
					}
				} catch(e) {
					alert(e);
				}
			}
		}
		
	} else {
		var filesString = aftereffects13.fileArrayToString (target);
		aftereffects13.executeScript("aftereffects13.open(" + filesString + ");");
	}
}



//-----------------------------------------------------------------
// The code below inserts the Place in After Effects menu item into the 
// place menu and sets up the onSelect and onDisplay routines for
// it.
//-----------------------------------------------------------------
if (BridgeTalk.appName == aftereffects13.BridgeTargetName) {
	// Use temp function to keep vars out of global namespace.
	aftereffects13.tempFunction = function () {
		
		placePlaceCommandName = {
			en: "In After Effects 13.5",
			fr: "Dans After Effects 13.5",
			de: "In After Effects 13.5",
			it: "In After Effects 13.5",
			es: "En After Effects 13.5",
			ja: "After Effects 13.5 内",
			ko: "After Effects 13.5에서 열기",
			ar: "في After Effects 13.5",
			cs: "Do After Effects 13.5",
			da: "I After Effects 13.5",
			el: "Στο After Effects 13.5",
			fi: "After Effects 13.5",
			he: "ב-After Effects 13.5",
			hu: "After Effects 13.5ban",
			nb: "I After Effects 13.5",
			nl: "In After Effects 13.5",
			pl: "W programie After Effects 13.5",
			pt: "No After Effects 13.5",
			ru: "В After Effects 13.5",
			sv: "I After Effects 13.5",
			tr: "After Effects 13.5’ta",
			uk: "У After Effects 13.5",
			zh: "在 After Effects 13.5 中"
		};
		
		var placeMenuItem = MenuElement.create ("command",
												localize (placePlaceCommandName),
												'at the end of submenu/Place',
												'PlaceInAE13.5');
												
		shouldPlaceInAEMenuItemBeEnabled = function () {
			var enableMenuItem = (BridgeTalk.isRunning (aftereffects13.AfterEffectsAppName) &&
				(app.document.selectionLength >= 1));
				
			if (enableMenuItem) {
				for (var i = 0; i < app.document.selectionLength; i++) {
					if (app.document.selections[i].container) {
						enableMenuItem = false;
						break;
					}
				}
			}
			
			return enableMenuItem;
		}
		
		placeSelectedFiles = function () {
			try {
				var sels = app.document.groupedSelections;
				var files = [];
				
				for (var i = 0; i < sels.length; i++) {
					var sub_sels = sels[i];
					var sub_files = [];
					for (var j = 0; j < sub_sels.length; j++) {
						sub_files[j] = sub_sels[j].spec;
					}
					files[i] = sub_files;
				}
				aftereffects13.open(files);
			}
			catch (error) {
				alert (error);
			}
		}
		
		placeMenuItem.onDisplay = function () {
			this.enabled = shouldPlaceInAEMenuItemBeEnabled();
		}
			
		placeMenuItem.onSelect = function () {
			placeSelectedFiles();
		}
		
		
		
		placeThumbCommandName = {
			en: "Place In Adobe After Effects CC 2015",
			fr: "Importer dans Adobe After Effects CC 2015",
			de: "In Adobe After Effects CC 2015 platzieren",
			it: "Inserisci in Adobe After Effects CC 2015",
			es: "Colocar en Adobe After Effects CC 2015",
			ja: "Adobe After Effects CC 2015 内に配置",
			ko: "Adobe After Effects CC 2015에 가져오기"
		};
		
		var contextPlaceMenuItem = MenuElement.create ("command",
												localize (placeThumbCommandName),
												'at the end of Thumbnail',
												'ContextPlaceInAE2015');
		
		contextPlaceMenuItem.onDisplay = function () {
			this.enabled = shouldPlaceInAEMenuItemBeEnabled();
		}
		
		contextPlaceMenuItem.onSelect = function () {
			placeSelectedFiles();
		}
	}
	
	aftereffects13.tempFunction ();
	delete aftereffects13.tempFunction;
}	




aftereffects13.quit = function()
{
	if (BridgeTalk.appName == aftereffects13.AfterEffectsAppName && 
			BridgeTalk.appVersion == aftereffects13.AfterEffectsVersion) {
		app.quit();
	} else {
		aftereffects13.executeScript("app.quit();");
	}
}

// if this is the highest installed version of aftereffects, then
aftereffects = aftereffects13;
//alert( "Loaded successfully.");